/*
* Copyright 2019-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* SPDX-License-Identifier:	GPL-2.0+
*/

#ifndef _RING_PLATFORM_FEATURES_H_
#define _RING_PLATFORM_FEATURES_H_

#include <ring_config.h>

/* Version 1 OTP NAND */
#define META_DATA_PAGE 0
#define PROD_KEY_PAGE 1
#define DEV_KEY_PAGE  2
#define BL_KEY_OFFSET             0  /* PAGE 1 & 2 */
#define KERN_KEY_OFFSET         256  /* PAGE 1 & 2 */
#define RTOS_KEY_OFFSET         512  /* PAGE 1 & 2 */
#define FULL_UNLOCK_KEY_OFFSET  768  /* PAGE 1 ONLY */
#define MFG_UNLOCK_KEY_OFFSET  1024  /* PAGE 1 ONLY */
/* Version 2 OTP NAND */
#define IPL_KEY_OFFSET         1280  /* PAGE 1 ONLY */
#define COCOA_PROD_KEYS_SIG_SIZE 256
#define OTP_VERSION_MAX 2

struct otp_meta {
	uint8_t  magic[8];
	uint32_t version;
	uint8_t  board_id[16];
	uint8_t  dsn[16];
	uint8_t prod_keys_sig[COCOA_PROD_KEYS_SIG_SIZE]; // Version 2 OTP NAND
};

#define RSA_KEYSIZE 256

void get_ring_config(ring_config *config);
int ring_config_reset(ring_config *config);
int set_ring_config(ring_config *config);
int do_ring_autoboot(void);
int read_otp_page(int page, u_char *addr, size_t size_to_read, int dev);
int load_ring_public_key(u8* key_load_addr, int key_page, int key_offset, int key_size);

#endif
